/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.essentials.gui;

import com.Da_Technomancer.essentials.blocks.redstone.RedstoneUtil;
import com.Da_Technomancer.essentials.gui.container.CircuitContainer;
import com.Da_Technomancer.essentials.packets.EssentialsPackets;
import com.Da_Technomancer.essentials.packets.SendNBTToServer;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CircuitScreen<T extends CircuitContainer>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation SEARCH_BAR_TEXTURE = new ResourceLocation("essentials", "textures/gui/search_bar.png");
    protected static final ResourceLocation UI_TEXTURE = new ResourceLocation("essentials", "textures/gui/circuit_filler_back.png");
    protected EditBox[] inputBars;
    private static final Predicate<String> validator = s -> {
        String whitelist = "0123456789 xX*/+-^piPIeE().";
        for (int i = 0; i < s.length(); ++i) {
            if ("0123456789 xX*/+-^piPIeE().".contains(s.substring(i, i + 1))) continue;
            return false;
        }
        return true;
    };

    public CircuitScreen(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.inputBars = new EditBox[((CircuitContainer)this.f_97732_).inputBars()];
        this.f_97726_ = 176;
        this.f_97727_ = 90;
    }

    protected void createTextBar(int id, int x, int y, Component text) {
        this.inputBars[id] = new EditBox(this.f_96547_, this.f_97735_ + x, this.f_97736_ + y, 140, 18, text);
        this.inputBars[id].m_94190_(true);
        this.inputBars[id].m_94202_(-1);
        this.inputBars[id].m_94205_(-1);
        this.inputBars[id].m_94182_(false);
        this.inputBars[id].m_94199_(20);
        this.inputBars[id].m_94144_(((CircuitContainer)this.f_97732_).inputs[id]);
        this.inputBars[id].m_94151_(this::entryChanged);
        this.inputBars[id].m_94153_(validator);
        this.m_7787_((GuiEventListener)this.inputBars[id]);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        int i;
        String[] text = new String[this.inputBars.length];
        for (i = 0; i < this.inputBars.length; ++i) {
            text[i] = this.inputBars[i].m_94155_();
        }
        this.m_6575_(minecraft, width, height);
        for (i = 0; i < this.inputBars.length; ++i) {
            this.inputBars[i].m_94144_(text[i]);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
        }
        for (EditBox bar : this.inputBars) {
            if (!bar.m_7933_(keyCode, scanCode, modifiers) && !bar.m_94204_()) continue;
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        for (EditBox bar : this.inputBars) {
            bar.m_6305_(matrix, mouseX, mouseY, partialTicks);
        }
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)UI_TEXTURE);
        this.m_93228_(matrix, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, 90);
        RenderSystem.m_157456_((int)0, (ResourceLocation)SEARCH_BAR_TEXTURE);
        for (EditBox bar : this.inputBars) {
            CircuitScreen.m_93133_((PoseStack)matrix, (int)(bar.f_93620_ - 2), (int)(bar.f_93621_ - 8), (float)0.0f, (float)0.0f, (int)144, (int)18, (int)144, (int)18);
        }
        for (EditBox inputBar : this.inputBars) {
            this.f_96547_.m_92889_(matrix, inputBar.m_6035_(), (float)(inputBar.f_93620_ - 2), (float)(inputBar.f_93621_ - 16), 0x404040);
        }
    }

    protected void m_7027_(PoseStack matrix, int x, int y) {
    }

    protected void entryChanged(String newFilter) {
        CompoundTag nbt = new CompoundTag();
        for (int i = 0; i < this.inputBars.length; ++i) {
            float output = RedstoneUtil.interpretFormulaString(this.inputBars[i].m_94155_());
            ((CircuitContainer)this.f_97732_).inputs[i] = this.inputBars[i].m_94155_();
            nbt.m_128350_("value_" + i, output);
            nbt.m_128359_("text_" + i, ((CircuitContainer)this.f_97732_).inputs[i]);
        }
        if (((CircuitContainer)this.f_97732_).pos != null) {
            EssentialsPackets.channel.sendToServer((Object)new SendNBTToServer(nbt, ((CircuitContainer)this.f_97732_).pos));
        }
    }
}

